﻿//////////////////////////////////////////////
// TextureAddressMode.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Standards --------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Enum -------------------------------------

namespace nkGraphics
{
	enum class TEXTURE_ADDRESS_MODE
	{
		MODE_WRAP         = 1,
		MODE_MIRROR       = 2,
		MODE_CLAMP        = 3,
		MODE_BORDER       = 4,
		MODE_MIRROR_ONCE  = 5
	} ;

	class DLL_GRAPHICS_EXPORT TextureAddressModeUtils final
	{
		public :

			// Conversions
			static nkMemory::StringView toString (TEXTURE_ADDRESS_MODE value) ;
			static TEXTURE_ADDRESS_MODE fromString (nkMemory::StringView value) ;
			static TEXTURE_ADDRESS_MODE fromIndex (unsigned int value) ;
	} ;
}